from BaseHTTPServer import BaseHTTPRequestHandler, HTTPServer
import logger1

class fakewebserver(BaseHTTPRequestHandler):

    def send_response(self, code, message=None):  #overriding
        """Send the response header and log the response code.

        Also send two standard headers with the server software
        version and the current date.

        """
        self.log_request(code)
        if message is None:
            if code in self.responses:
                message = self.responses[code][0]
            else:
                message = ''
        if self.request_version != 'HTTP/0.9':
            self.wfile.write("%s %d %s\r\n" %
                             (self.protocol_version, code, message))

        self.send_header('Server', "mohit raj")
        self.send_header('Tip',"Stay away")
        self.send_header('Date', self.date_time_string())
        str1 = self.client_address[0]+" -- "+self.log_date_time_string()
        logger1.logger.info(str1)


    def _set_headers(self):
        self.send_response(200)
        #self.send_header('mohit', 'raj')
        self.end_headers()

    def do_GET(self):
        self._set_headers()
        self.wfile.write("<html><body><h1>hi!</h1></body></html>")

    def do_HEAD(self):
        self._set_headers()

    def do_POST(self):
        # Doesn't do anything with posted data
        self._set_headers()
        self.wfile.write("<html><body><h1>POST!</h1></body></html>")

def start(port=80):
    server_address = ('', port)
    httpd = HTTPServer(server_address, fakewebserver)
    print 'Starting Server...'
    httpd.serve_forever()


if __name__ == "__main__":
    start()