$(document).ready(function() {

    $('#categoriesSelector').change(function() {
        var $selector = $(this);
        var selectedIndex = +$selector.val();
        var $dashboardCategories = $('.dashboardCategory');
        var $selectedItem = $dashboardCategories.eq(selectedIndex).show();
        $dashboardCategories.not($selectedItem).hide();
    });

    function setupBoxCloseButton($box) {
        $box.find('.boxCloseButton').click(function() {
            $(this).closest('.boxsizer').remove();
        });
    }

    // make the close button of the hint box work
    setupBoxCloseButton($('.box'));

    $('.dashboardCategory button').on('click', function() {
        var $button = $(this);
        var boxHtml = '<div class="boxsizer"><article class="box">' +
                '<header class="boxHeader">' +
                    $button.text() +
                    '<button class="boxCloseButton">&#10006;</button>'+
                '</header>' +
                'Information box regarding ' + $button.text() +
            '</article></div>';
        $('.boxContainer').append(boxHtml);
        setupBoxCloseButton($('.box:last-child'));
    });

});
