// Fake xhr
jqXHR = {
	readyState: 0,

	// Builds headers hashtable if needed
	getResponseHeader: function( key ) {
		var match;
		if ( state === 2 ) {
			if ( !responseHeaders ) {
				responseHeaders = {};
				while ( ( match = rheaders.exec( responseHeadersString ) ) ) {
					responseHeaders[ match[ 1 ].toLowerCase() ] = match[ 2 ];
				}
			}
			match = responseHeaders[ key.toLowerCase() ];
		}
		return match == null ? null : match;
	},

	// Raw string
	getAllResponseHeaders: function() {
		return state === 2 ? responseHeadersString : null;
	},

	// Caches the header
	setRequestHeader: function( name, value ) {
		var lname = name.toLowerCase();
		if ( !state ) {
			name = requestHeadersNames[ lname ] = requestHeadersNames[ lname ] || name;
			requestHeaders[ name ] = value;
		}
		return this;
	},

	// Overrides response content-type header
	overrideMimeType: function( type ) {
		if ( !state ) {
			s.mimeType = type;
		}
		return this;
	},

	// Status-dependent callbacks
	statusCode: function( map ) {
		var code;
		if ( map ) {
			if ( state < 2 ) {
				for ( code in map ) {

					// Lazy-add the new callback in a way that preserves old ones
					statusCode[ code ] = [ statusCode[ code ], map[ code ] ];
				}
			} else {

				// Execute the appropriate callbacks
				jqXHR.always( map[ jqXHR.status ] );
			}
		}
		return this;
	},

	// Cancel the request
	abort: function( statusText ) {
		var finalText = statusText || strAbort;
		if ( transport ) {
			transport.abort( finalText );
		}
		done( 0, finalText );
		return this;
	}
};