(function() {
	'use strict';

	window.dataDrivenQuiz = window.dataDrivenQuiz || {};

	function MultipleChoiceBuilder() {
		this.title = 'Untitled';
		this.options = [];
	}
	dataDrivenQuiz.MultipleChoiceBuilder = MultipleChoiceBuilder;

	MultipleChoiceBuilder.prototype.setTitle = function(title) {
		this.title = title;
		return this;
	};

	MultipleChoiceBuilder.prototype.setAcceptsMultiple = function(acceptsMultiple) {
		this.acceptsMultiple = acceptsMultiple;
		return this;
	};

	MultipleChoiceBuilder.prototype.addOption = function(title) {
		this.options.push(title);
		return this;
	};

	MultipleChoiceBuilder.prototype.getResult = function() {
		var $header = $('<header>').text(this.title || 'Untitled');

		var questionGuid = 'quizQuestion' + (jQuery.guid++);
		var $optionsList = $('<ul class="unstyled">');
		for (var i = 0; i < this.options.length; i++) {
			var $input = $('<input />').attr({
				'type': this.acceptsMultiple ? 'checkbox' : 'radio',
				'value': i,
				'name': questionGuid,
			});
			
			var $option = $('<li>');
			$('<label>').append($input, $('<span>').text(this.options[i]))
				.appendTo($option);
			$optionsList.append($option);
		}
		return $('<article>').append($header, $optionsList);
	};

	dataDrivenQuiz.init = function() {
		for (var i = 0; i < dataDrivenQuiz.questions.length; i++) {
			var question = dataDrivenQuiz.questions[i];
			var builder = new dataDrivenQuiz.MultipleChoiceBuilder();

			builder.setTitle(question.title)
				.setAcceptsMultiple(question.acceptsMultiple);

			for (var j = 0; j < question.options.length; j++) {
				builder.addOption(question.options[j]);
			}

			var quizElement = builder.getResult();
			$('form').append(quizElement);
		}
	};

	$(document).ready(dataDrivenQuiz.init);

	dataDrivenQuiz.questions = [{
		title: 'Which is the most preferred way to write our JavaScript code?',
		options: [
			'inline along with our HTML',
			'flat inside *.js files',
			'in small Modules, one per *.js file'
		]
	}, {
		title: 'What does the $() function returns when invoked with a CSS selector?',
		options: [
			'a single element',
			'an array of elements',
			'the HTML of the selected element',
			'a Composite Object'
		]
	}, {
		title: 'Which of the following are Design Patterns',
		acceptsMultiple: true,
		options: [
			'Garbage Collector',
			'Class',
			'Object Literal',
			'Observer'
		]
	}, {
		title: 'How can get a hold to the <body> element of a page?',
		acceptsMultiple: true,
		options: [
			'document.body',
			'document.getElementsByTagName(\'body\')[0]',
			'$(\'body\')[0]',
			'document.querySelector(\'body\')'
		]
	}];

})();
