(function() {
	'use strict';

	window.dataDrivenForm = window.dataDrivenForm || {};

	dataDrivenForm.formElementHTMLFactory = function (type, name, title) {
		if (!title || !title.length) {
			title = name;
		}
		var topPart = '<div><label><span>' + title + ':</span><br />';
		var bottomPart = '</label></div>';
		if (type === 'text') {
			return topPart +
				'<input type="text" maxlength="200" name="' + name + '" />' +
				bottomPart;
		} else if (type === 'email') {
			return topPart +
				'<input type="email" required name="' + name + '" />' +
				bottomPart;
		} else if (type === 'number') {
			return topPart +
				'<input type="number" min="0" max="2147483647" name="' + name + '" />' +
				bottomPart;
		} else if (type === 'date') {
			return topPart +
				'<input type="date" min="1900-01-01" name="' + name + '" />' +
				bottomPart;
		} else if (type === 'textarea') {
			return topPart +
				'<textarea cols="30" rows="3" maxlength="800" name="' + name + '" />' +
				bottomPart;
		} else if (type === 'checkbox') {
			return '<div><label><span>' + title + ':</span>' +
				'<input type="checkbox" name="' + name + '" />' +
				'</label></div>';
		} else if (type === 'notice') {
			return '<p>' + name + '</p>';
		}  else if (type === 'button') {
			return '<button name="' + name + '">' + title + '!</button>';
		}
	};

	dataDrivenForm.init = function() {
		for (var i = 0; i < dataDrivenForm.parts.length; i++) {
			var part = dataDrivenForm.parts[i];
			var elementHTML = dataDrivenForm.formElementHTMLFactory(part.type, part.name, part.title);
			// check if the result is null, undefined or empty string
			if (elementHTML && elementHTML.length) {
				$('form').append(elementHTML);
			}
		}
	};
	$(document).ready(dataDrivenForm.init);

	dataDrivenForm.parts = [{
		type: 'text',
		name: 'firstname',
		title: 'Firt Name'
	}, {
		type: 'text',
		name: 'lastname',
		title: 'Last Name'
	}, {
		type: 'email',
		name: 'email',
		title: 'e-mail address'
	}, {
		type: 'date',
		name: 'birthdate',
		title: 'Date of birth'
	}, {
		type: 'number',
		name: 'experience',
		title: 'Years of experience'
	}, {
		type: 'textarea',
		name: 'summary',
		title: 'Summary'
	}, {
		type: 'checkbox',
		name: 'receivenotifications',
		title: 'Receive notification e-mails'
	}, {
		type: 'notice',
		name: 'By using this form you accept the terms of use'
	}, {
		type: 'button',
		name: 'save'
	}, {
		type: 'button',
		name: 'submit'
	}];

})();
