var d = $.Deferred();
setTimeout(function() {
    d.resolve(7);
}, 2000);
var p = d.promise();

var d = $.Deferred(function (deferred) {
    setTimeout(function() {
        deferred.resolve(7);
    }, 2000);
});
var p = d.promise();

//or 
var p = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});

p.then(function(result) { // works the same in jQuery & ES6
    console.log(result);
}, function(error) {
    console.error('An error occurred: ', error);
});



//****************************
var p = $.Deferred(function (deferred) {
    deferred.reject(new Error('Something happened!'));
}).promise();

p.then(null, function(x) {
    console.error(x);
});

//or
var p = new Promise(function(resolve, reject) {
    reject(new Error('Something happened!'));
});
p.then(null, function(x) {
    console.error(x);
});



//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x);
});

//or
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x);
});



//****************************
var p = $.Deferred().reject(new Error('Something happened!')).promise();
p.fail(function(error) {
    console.error(error);
});

//or
var p = Promise.reject(new Error('Something happened!'));
p.catch(function(error) {
    console.error(error);
});



//****************************
//********* CHAINING *********
//****************************
var p = $.Deferred().resolve(7).promise();
p.then(null, function (error) {
    console.error('An error happened!'); // does not run, since the promise is resolved
}).then(function(x) {
    console.log(x); // logs 7
});

//or
var p = Promise.resolve(7);
p.then(null, function (error) {
    console.error('An error happened!'); // does not run, since the promise is resolved
}).then(function(x) {
    console.log(x); // logs 7
});


//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x); // logs 7
    return x * 3;
}).then(function(x) {
    console.log(x); // logs 21
});

//or
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x); // logs 7
    return x * 3;
}).then(function(x) {
    console.log(x); // logs 21
});

//****************************
var p = $.Deferred().resolve(7).promise();
p.then(function(x) {
    console.log(x); // logs 7
}).then(function(x) {
    console.log(x); // logs undefined
});

//or
var p = Promise.resolve(7);
p.then(function(x) {
    console.log(x); // logs 7
}).then(function(x) {
    console.log(x); // logs undefined
});




//****************************
var d = $.Deferred();
setTimeout(function() {
    d.resolve(7);
}, 2000);
var p = d.promise();

p.then(function(x) {
    console.log(x); // logs 7
    var d2 = $.Deferred();
    setTimeout(function() {
        d2.resolve(x*3);
    }, 2000);
    return d2.promise();
}).then(function(x) {
    console.log(x); // logs 21
});

//or
var p = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});
p.then(function(x) {
    console.log(x); // logs 7
    return new Promise(function(resolve) {
        setTimeout(function() {
            resolve(x*3);
        }, 2000);
    });
}).then(function(x) {
    console.log(x); // logs 21
});




//****************************
//******* COMPOSITION ********
//****************************
var p1 = $.Deferred(function (d1) {
    setTimeout(function() {
        d1.resolve(7);
    }, 2000);
}).promise();

var p2 = $.Deferred(function (d2) {
    setTimeout(function() {
        d2.resolve(11);
    }, 3000);
}).promise();

$.when(p1, p2).then(function(result1, result2) {
    console.log('p1', result1); // logs 7
    console.log('p2', result2); // logs 11
    // this can be used to make our code look like A+
    var results = arguments;
});

//or
var p1 = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(7);
    }, 2000);
});

var p2 = new Promise(function(resolve) {
    setTimeout(function() {
        resolve(11);
    }, 3000);
});

Promise.all([p1, p2]).then(function(results) {
    console.log('p1', results[0]); // logs 7
    console.log('p2', results[1]); // logs 11
});




//****************************
//***** INCONCISTENCIES ******
//****************************
var d = $.Deferred();
d.reject(new Error('Something happened!'));
var p = d.promise();

p.then(null, function(x) {
    console.log(x);
    return $.Deferred().resolve(5).promise();
}).then(function(x){
    console.log('Recovered', x);// prints: Recovered 5
});

p.then(null, function(x) {
    console.log(x);
    return 5;// no recovering, just changing the value
}).then(null, function(x){
    console.log('Not Recovered', x);// prints: Not Recovered 5
});

// fail never returns a new promise, so no recovering
p.fail(function(x) {
    console.log(x);
    return $.Deferred().resolve(5).promise();
    // return 5;
}).then(null, function(x){
    console.log('Not Recovered', x);// prints: Not Recovered Error...
});



//or
var p = new Promise(function(resolve, reject) {
    reject(new Error('Something happened!'));
});
p.then(null, function(x) {
    console.log(x);
}).then(function(){
    console.log('Recovered');
});

p.catch(function(x) {
    console.log(x);
}).then(function(){
    console.log('Recovered');
});



//****************************
var p = $.Deferred(function (deferred) {
    throw new Error('Something happened!'); // the execution stops here
}).promise().then(null, function(x) {
    console.log(x); // nothing gets printed
});

//vs
new Promise(function() {
    throw new Error('Something happened!');
}).then(null, function(x) {
    console.log(x);
});



//****************************
$.Deferred().resolve().promise().then(function() {
    throw new Error('Something happened!'); // the execution stops here
}).then(null, function(x) {
    console.log(x); // nothing gets printed
});

$.Deferred().resolve().promise().then(function() {
    try { // this is a workaround
        throw new Error('Something happened!');
    } catch (e) {
        return $.Deferred().reject(e).promise();
    }
}).then(function(){
    console.log('Success'); // not printed
}).then(null, function(x) { // almost equivalent to .fail()
    console.log(x); // logs 'Something happened!''
});

Promise.resolve().then(function() {
    throw new Error('Something happened!');
}).then(function(){
    console.log('Success'); // not printed
}).then(null, function(x) { // equivalent to .catch()
    console.log(x); // logs 'Something happened!''
});
