var jqueryPromise = $.Deferred().resolve('I will be A+ compliant').promise();
var p = Promise.resolve(jqueryPromise);
p.then(function(result) {
    console.log(result);
});

// that;s equivalent to
var jqueryPromise = $.Deferred().resolve('I will be A+ compliant').promise();
var p = new Promise(function (resolve, reject) {
    jqueryPromise.then(resolve, reject);
});
p.then(function(result) {
    console.log(result);
});

// $.getJSON() transformation example
var aPlusAjaxPromise = Promise.resolve($.getJSON('AjaxContent.json'));
aPlusAjaxPromise.then(function(result) {
    console.log(result);
});


// from A+ to jQuery Promise
var aPromise = Promise.resolve('I will be a jQuery Promise');
var p = $.Deferred(function (deferred) {
    aPromise.then(function(result) {
        return deferred.resolve(result);
    }, function(error) {
        return deferred.reject(error);
    });
}).promise();
p.then(function(result) {
    console.log(result);
});
