(function() {
    'use strict';

    dashboard.informationBox = dashboard.informationBox || {};

    var $boxContainer = null;

    dashboard.informationBox.init = function() {
        $boxContainer = dashboard.$container.find('.boxContainer');

        $boxContainer.on('click', '.boxCloseButton', function() {
            var $button = $(this);
            dashboard.informationBox.close($button);
        });
    };

    dashboard.informationBox.openNew = function(itemName) {
        var $box = $('<div class="boxsizer"><article class="box">' +
                '<header class="boxHeader">' +
                    '<button class="boxCloseButton">&#10006;</button>' +
                    itemName +
                '</header>' +
                '<div class="boxContent">Loading...</div>' +
            '</article></div>');
        $boxContainer.append($box);

        dashboard.videoService.getVideo(itemName).then(function(result) {
            var $a = $('<a>').attr('href', dashboard.videoService.getVideoUrl(result.id.videoId));
            $a.append($('<img />').attr('src', result.snippet.thumbnails.medium.url));
            $box.find('.boxContent').empty().append($a);
        }).fail(function() {
            $buttonContainer.html('An error occurred!');
        });
    };

    dashboard.informationBox.close = function($boxElement) {
        $boxElement.closest('.boxsizer').remove();
    };

})();
