/*
 * Decompiled with CFR 0.152.
 */
package com.blundell.tut;

import com.blundell.tut.InvalidTemperatureException;

public final class TemperatureConverter {
    static final double ABSOLUTE_ZERO_C = -273.15;
    static final double ABSOLUTE_ZERO_F = -459.67;
    private static final String ERROR_MESSAGE_BELOW_ZERO_FMT = "Invalid temperature: %.2f%c below absolute zero";

    private TemperatureConverter() {
    }

    public static double fahrenheitToCelsius(double fahrenheit) {
        if (fahrenheit < -459.67) {
            String msg = String.format(ERROR_MESSAGE_BELOW_ZERO_FMT, fahrenheit, Character.valueOf('F'));
            throw new InvalidTemperatureException(msg);
        }
        return (fahrenheit - 32.0) / 1.8;
    }

    public static double celsiusToFahrenheit(double celsius) {
        if (celsius < -273.15) {
            String msg = String.format(ERROR_MESSAGE_BELOW_ZERO_FMT, celsius, Character.valueOf('C'));
            throw new InvalidTemperatureException(msg);
        }
        return celsius * 1.8 + 32.0;
    }
}

