﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using OpenQA.Selenium;
using OpenQA.Selenium.Remote;
using System.Text;
using OpenQA.Selenium.Firefox;

namespace WebAppTest
{
    [TestClass]
    public class SeleniumTests
    {
        private IWebDriver driver;
        private StringBuilder verificationErrors;
        private string baseURL;
        private string hubURL;

        public TestContext TestContext{ get; set; }

        [TestInitialize]
        public void SetupTest()
        {

            baseURL = @"http://gopiazurewebapp21.azurewebsites.net";
            hubURL = @"http://127.0.0.1:4440/wd/hub";
            //baseURL = this.TestContext.Properties["webAppUrl"].ToString();
            //hubURL = this.TestContext.Properties["GridHub"].ToString();
            verificationErrors = new StringBuilder();
        }

        [TestCleanup]
        public void TeardownTest()
        {
            try
            {
                driver.Quit();
                driver.Dispose();
            }
            catch (Exception)
            {
                // Ignore errors if unable to close the browser
            }
            Assert.AreEqual("", verificationErrors.ToString());
        }

        [TestMethod]
        [Priority(1)]
        [TestCategory("FireFox")]
        public void Selenium_ClickApplicationName_Firefox()
        {
            CreateRemoteDriver("firefox");
            Selenium_ClickApplicationName();
        }

        [TestMethod]
        [Priority(1)]
        [TestCategory("Chrome")]
        public void Selenium_ClickApplicationName_Chrome()
        {
            CreateRemoteDriver("chrome");
            Selenium_ClickApplicationName();
        }

        [TestMethod]
        [Priority(0)]
        [TestCategory("FireFox")]
        public void Selenium_ClickAbout_Firefox()
        {
            CreateRemoteDriver("firefox");
            Selenium_ClickAbout();
        }
        
        [TestMethod]
        [Priority(2)]
        [TestCategory("Chrome")]
        public void Selenium_ClickAbout_Chrome()
        {
            CreateRemoteDriver("chrome");
            Selenium_ClickAbout();
        }

        [TestMethod]
        [Priority(2)]
        [TestCategory("FireFox")]
        public void Selenium_ClickContact_Firefox()
        {
            CreateRemoteDriver("firefox");
            Selenium_ClickContact();
        }
        
        [TestMethod]
        [Priority(0)]
        [TestCategory("Chrome")]
        public void Selenium_ClickContact_Chrome()
        {
            CreateRemoteDriver("chrome");
            Selenium_ClickContact();
        }

        private void CreateRemoteDriver(string Browser)
        {
            DesiredCapabilities capability = new DesiredCapabilities();
            capability.SetCapability("browserName", Browser);
            Uri server = new Uri(hubURL);

            // driver = new ChromeDriver(DRIVER_PATH);
            this.driver = new RemoteWebDriver(server, capability);
            driver.Manage().Window.Maximize();
        }

        private void Selenium_ClickAbout()
        {
            driver.Navigate().GoToUrl(baseURL);
            driver.FindElement(By.LinkText("About")).Click();
        }

        private void Selenium_ClickContact()
        {
            driver.Navigate().GoToUrl(baseURL);
            driver.FindElement(By.LinkText("Contact")).Click();
        }

        private void Selenium_ClickApplicationName()
        {
            driver.Navigate().GoToUrl(baseURL);
            driver.FindElement(By.LinkText("Application name")).Click();
        }
    }
}