<?php
header('Content-Type: text/html; charset=utf-8');

$max_search_results = 20;
$query = isset($_REQUEST['query']) ? $_REQUEST['query'] : false;
$results = false;

if ($query)
{
  require_once('Apache/Solr/Service.php');
  $solr = new Apache_Solr_Service('localhost', 8983, '/solr/search/');
  try
  {
    $results = $solr->search($query, 0, $max_search_results);
  }
  catch (Exception $e)
  {
        die("<html><head><title>Error while Searching</title><body><pre>{$e->__toString()}</pre></body></html>");
  }
}
?>

<html>
    <head>
        <title>My Company Search</title>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8"></meta>
        <script type="text/javascript" src="searchpage_files/jquery-1.js"></script>
        <link rel="stylesheet" type="text/css" href="searchpage_files/file_004.css"></link>
        <link rel="stylesheet" href="searchpage_files/file.css" type="text/css"></link>
        <link rel="stylesheet" type="text/css" href="searchpage_files/file_003.css"></link>
        <link rel="stylesheet" type="text/css" href="searchpage_files/file_002.css"></link>
        <script type="text/javascript" src="searchpage_files/file_002"></script>
        <script type="text/javascript" src="searchpage_files/file"></script>
    </head>
    <body>
        <div class="admin">
            <span>
                <a href="http://localhost:8000/solr/">Home</a></span>
        </div>
        <div id="header" class="searchbar">
            <div id="head">
                <form  accept-charset="utf-8" method="get">
                    <table style="width:90%;">
                        <tbody>
                            <tr>
                                <td>
                                    <a href="http://www.mycompany.com/">
                                        <img src="searchpage_files/logo.jpg" id="logo"></img></a>
                                </td>
                                <td>
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>
                                                    <!--input class="searchBox" name="q" type="text"></input-->
													<input class="searchBox"id="query" name="query" type="text" value="<?php echo htmlspecialchars($query, ENT_QUOTES, 'utf-8'); ?>"/>
                                                </td>
                                                <td></td>
                                                <td>
                                                    <input class="gbqfb" id="querySubmit" value="Search" type="submit"></input>
                                                </td>
                                                <td></td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </form>
            </div>
        </div>
        <div id="content">
 
<div class="result-document">
	<span class="result-document-line1">
<?php

// display results
if ($results)
{
  $total = (int) $results->response->numFound;
  $start = min(1, $total);
  $end = min($limit, $total);
?>
    <div>Results <?php echo $start; ?> - <?php echo $end;?> of <?php echo $total; ?>:</div>
  
<?php
  // iterate result documents
  
  foreach ($results->response->docs as $doc)
  {
?>
  <p class="result-document-line2">    
        <img src="searchpage_files/text.jpg" style="border:0.5px;" width="20"></img>
<?php
    // iterate document fields / values
    foreach ($doc as $field => $value)
    {
?>
          <font color="#330099"><?php echo htmlspecialchars($field, ENT_NOQUOTES, 'utf-8'); ?></font> : <?php echo htmlspecialchars($value, ENT_NOQUOTES, 'utf-8'); ?></br>

<?php
    }
?>
      </p></br></br>
<?php
  }
?>
    </ol>
<?php
}
?>
		
<!--
	<img src="searchpage_files/Excel-32-d.gif" style="border:0px;" width="20"></img><font color="red"></font><font color="#330099">[Pages:
	,
	Words: ]</font><!--font color="#9900CC">				</font><font color="#717100">[Created
	On:
	2011-04-06T06:53:04Z
	,
	Company: ]</font><font color="#339933"></font></a></span>
	<p class="result-document-line2">http://172.16.90.18:10001/OpenKM/com.openkm.frontend.Main/index.jsp?docPath=/okm:root/EITS
									 Sales Repository/Profiles/employee skills.xls</p>
	<p class="result-document-line3">Author:- , &nbsp;&nbsp;Last Updated By:-
									 hari.shankar</p>
	<p class="result-document-line4">Creation-Date</p>
	<p class="result-document-line5">
		Score: 1.0
		
	</p>
</div-->
        </div>
        <div id="footer">
            <hr></hr>
            <div class="footer">Copyrights: My Company (2001, 2014)</div>
        </div>
    </body>
</html>
