/*
 * Decompiled with CFR 0.152.
 */
package storm.contrib.solr;

import backtype.storm.task.OutputCollector;
import backtype.storm.task.TopologyContext;
import backtype.storm.topology.base.BaseRichBolt;
import backtype.storm.tuple.Tuple;
import java.io.IOException;
import java.util.Map;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.common.SolrInputDocument;

public abstract class SolrBolt
extends BaseRichBolt {
    private OutputCollector collector;
    private SolrServer solrServer;
    private final String solrAddress;

    protected SolrBolt(String solrAddress) {
        this.solrAddress = solrAddress;
    }

    public void prepare(Map conf, TopologyContext context, OutputCollector collector) {
        this.collector = collector;
        try {
            this.solrServer = new HttpSolrServer(this.solrAddress);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute(Tuple input) {
        if (this.shouldActOnInput(input)) {
            SolrInputDocument document = this.getSolrInputDocumentForInput(input);
            if (document != null) {
                try {
                    this.solrServer.add(document);
                    this.collector.ack(input);
                }
                catch (SolrServerException e) {
                    e.printStackTrace();
                    this.collector.fail(input);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.collector.fail(input);
                }
            }
        } else {
            this.collector.ack(input);
        }
    }

    public abstract boolean shouldActOnInput(Tuple var1);

    public abstract SolrInputDocument getSolrInputDocumentForInput(Tuple var1);

    public void cleanup() {
    }
}

