/*
 * Decompiled with CFR 0.152.
 */
package storm.contrib.solr;

import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.tuple.Tuple;
import java.util.Date;
import org.apache.solr.common.SolrInputDocument;
import storm.contrib.solr.SolrBolt;

public class SimpleSolrBolt
extends SolrBolt {
    public SimpleSolrBolt(String solrAddress) {
        super(solrAddress);
    }

    @Override
    public boolean shouldActOnInput(Tuple input) {
        return true;
    }

    @Override
    public SolrInputDocument getSolrInputDocumentForInput(Tuple input) {
        SolrInputDocument document = new SolrInputDocument();
        for (String field : input.getFields()) {
            Object value = input.getValueByField(field);
            if (!this.isValidField(value)) continue;
            document.addField(field, value);
        }
        return document;
    }

    private boolean isValidField(Object value) {
        return value instanceof String || value instanceof Date || value instanceof Integer || value instanceof Float || value instanceof Double || value instanceof Short || value instanceof Long;
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }
}

