/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.tools;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import storm.starter.tools.Rankable;

public class Rankings
implements Serializable {
    private static final long serialVersionUID = -1549827195410578903L;
    private static final int DEFAULT_COUNT = 10;
    private final int maxSize;
    private final List<Rankable> rankedItems = Lists.newArrayList();

    public Rankings() {
        this(10);
    }

    public Rankings(int topN) {
        if (topN < 1) {
            throw new IllegalArgumentException("topN must be >= 1");
        }
        this.maxSize = topN;
    }

    public Rankings(Rankings other) {
        this(other.maxSize());
        this.updateWith(other);
    }

    public int maxSize() {
        return this.maxSize;
    }

    public int size() {
        return this.rankedItems.size();
    }

    public List<Rankable> getRankings() {
        LinkedList<Rankable> copy = Lists.newLinkedList();
        for (Rankable r : this.rankedItems) {
            copy.add(r.copy());
        }
        return ImmutableList.copyOf(copy);
    }

    public void updateWith(Rankings other) {
        for (Rankable r : other.getRankings()) {
            this.updateWith(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWith(Rankable r) {
        List<Rankable> list = this.rankedItems;
        synchronized (list) {
            this.addOrReplace(r);
            this.rerank();
            this.shrinkRankingsIfNeeded();
        }
    }

    private void addOrReplace(Rankable r) {
        Integer rank = this.findRankOf(r);
        if (rank != null) {
            this.rankedItems.set(rank, r);
        } else {
            this.rankedItems.add(r);
        }
    }

    private Integer findRankOf(Rankable r) {
        Object tag = r.getObject();
        for (int rank = 0; rank < this.rankedItems.size(); ++rank) {
            Object cur = this.rankedItems.get(rank).getObject();
            if (!cur.equals(tag)) continue;
            return rank;
        }
        return null;
    }

    private void rerank() {
        Collections.sort(this.rankedItems);
        Collections.reverse(this.rankedItems);
    }

    private void shrinkRankingsIfNeeded() {
        if (this.rankedItems.size() > this.maxSize) {
            this.rankedItems.remove(this.maxSize);
        }
    }

    public void pruneZeroCounts() {
        int i = 0;
        while (i < this.rankedItems.size()) {
            if (this.rankedItems.get(i).getCount() == 0L) {
                this.rankedItems.remove(i);
                continue;
            }
            ++i;
        }
    }

    public String toString() {
        return this.rankedItems.toString();
    }

    public Rankings copy() {
        return new Rankings(this);
    }
}

