/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.tools;

import backtype.storm.tuple.Tuple;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import storm.starter.tools.Rankable;

public class RankableObjectWithFields
implements Rankable,
Serializable {
    private static final long serialVersionUID = -9102878650001058090L;
    private static final String toStringSeparator = "|";
    private final Object obj;
    private final long count;
    private final ImmutableList<Object> fields;

    public RankableObjectWithFields(Object obj, long count, Object ... otherFields) {
        if (obj == null) {
            throw new IllegalArgumentException("The object must not be null");
        }
        if (count < 0L) {
            throw new IllegalArgumentException("The count must be >= 0");
        }
        this.obj = obj;
        this.count = count;
        this.fields = ImmutableList.copyOf(otherFields);
    }

    public static RankableObjectWithFields from(Tuple tuple) {
        ArrayList otherFields = Lists.newArrayList(tuple.getValues());
        Object obj = otherFields.remove(0);
        Long count = (Long)otherFields.remove(0);
        return new RankableObjectWithFields(obj, count, otherFields.toArray());
    }

    @Override
    public Object getObject() {
        return this.obj;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    public List<Object> getFields() {
        return this.fields;
    }

    @Override
    public int compareTo(Rankable other) {
        long delta = this.getCount() - other.getCount();
        if (delta > 0L) {
            return 1;
        }
        if (delta < 0L) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RankableObjectWithFields)) {
            return false;
        }
        RankableObjectWithFields other = (RankableObjectWithFields)o;
        return this.obj.equals(other.obj) && this.count == other.count;
    }

    public int hashCode() {
        int result = 17;
        int countHash = (int)(this.count ^ this.count >>> 32);
        result = 31 * result + countHash;
        result = 31 * result + this.obj.hashCode();
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        buf.append(this.obj);
        buf.append(toStringSeparator);
        buf.append(this.count);
        for (Object e : this.fields) {
            buf.append(toStringSeparator);
            buf.append(e);
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public Rankable copy() {
        ImmutableList<Object> shallowCopyOfFields = ImmutableList.copyOf(this.getFields());
        return new RankableObjectWithFields(this.getObject(), this.getCount(), shallowCopyOfFields);
    }
}

