/*
 * Decompiled with CFR 0.152.
 */
package storm.starter.bolt;

import backtype.storm.topology.BasicOutputCollector;
import backtype.storm.topology.OutputFieldsDeclarer;
import backtype.storm.topology.base.BaseBasicBolt;
import backtype.storm.tuple.Fields;
import backtype.storm.tuple.Tuple;
import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import storm.starter.tools.Rankings;
import storm.starter.util.TupleHelpers;

public abstract class AbstractRankerBolt
extends BaseBasicBolt {
    private static final long serialVersionUID = 4931640198501530202L;
    private static final int DEFAULT_EMIT_FREQUENCY_IN_SECONDS = 2;
    private static final int DEFAULT_COUNT = 10;
    private final int emitFrequencyInSeconds;
    private final int count;
    private final Rankings rankings;

    public AbstractRankerBolt() {
        this(10, 2);
    }

    public AbstractRankerBolt(int topN) {
        this(topN, 2);
    }

    public AbstractRankerBolt(int topN, int emitFrequencyInSeconds) {
        if (topN < 1) {
            throw new IllegalArgumentException("topN must be >= 1 (you requested " + topN + ")");
        }
        if (emitFrequencyInSeconds < 1) {
            throw new IllegalArgumentException("The emit frequency must be >= 1 seconds (you requested " + emitFrequencyInSeconds + " seconds)");
        }
        this.count = topN;
        this.emitFrequencyInSeconds = emitFrequencyInSeconds;
        this.rankings = new Rankings(this.count);
    }

    protected Rankings getRankings() {
        return this.rankings;
    }

    public final void execute(Tuple tuple, BasicOutputCollector collector) {
        if (TupleHelpers.isTickTuple(tuple)) {
            this.getLogger().debug((Object)"Received tick tuple, triggering emit of current rankings");
            this.emitRankings(collector);
        } else {
            this.updateRankingsWithTuple(tuple);
        }
    }

    abstract void updateRankingsWithTuple(Tuple var1);

    private void emitRankings(BasicOutputCollector collector) {
        collector.emit((List)new Values(new Object[]{this.rankings.copy()}));
        this.getLogger().debug((Object)("Rankings: " + this.rankings));
    }

    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields(new String[]{"rankings"}));
    }

    public Map<String, Object> getComponentConfiguration() {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.tick.tuple.freq.secs", this.emitFrequencyInSeconds);
        return conf;
    }

    abstract Logger getLogger();
}

