/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.DBCursor;
import com.mongodb.jdbc.Executor;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class MongoStatement
implements Statement {
    MongoConnection _conn;
    final int _type;
    final int _concurrency;
    final int _holdability;
    int _fetchSize = 0;
    int _maxRows = 0;
    MongoResultSet _last;

    MongoStatement(MongoConnection conn, int type, int concurrency, int holdability) {
        this._conn = conn;
        this._type = type;
        this._concurrency = concurrency;
        this._holdability = holdability;
    }

    @Override
    public void addBatch(String sql) {
        throw new UnsupportedOperationException("batch not supported");
    }

    @Override
    public void clearBatch() {
        throw new UnsupportedOperationException("batch not supported");
    }

    @Override
    public int[] executeBatch() {
        throw new UnsupportedOperationException("batch not supported");
    }

    @Override
    public void cancel() {
        throw new RuntimeException("not supported yet - can be");
    }

    @Override
    public void close() {
        this._conn = null;
    }

    @Override
    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public boolean isClosed() {
        return this._conn == null;
    }

    @Override
    public boolean isPoolable() {
        return true;
    }

    @Override
    public void setPoolable(boolean poolable) {
        if (!poolable) {
            throw new RuntimeException("why don't you want me to be poolable?");
        }
    }

    @Override
    public void clearWarnings() {
        throw new RuntimeException("not supported yet - can be");
    }

    @Override
    public boolean execute(String sql) {
        try {
            this.executeQuery(sql);
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) {
        throw new RuntimeException("execute not done");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) {
        throw new RuntimeException("execute not done");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) {
        throw new RuntimeException("execute not done");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return new Executor(this._conn._db, sql).writeop();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) {
        throw new RuntimeException("executeUpdate not done");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) {
        throw new RuntimeException("executeUpdate not done");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) {
        throw new RuntimeException("executeUpdate not done");
    }

    @Override
    public int getUpdateCount() {
        throw new RuntimeException("getUpdateCount not done");
    }

    @Override
    public ResultSet getGeneratedKeys() {
        throw new RuntimeException("getGeneratedKeys notn done");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        DBCursor cursor = new Executor(this._conn._db, sql).query();
        if (this._fetchSize > 0) {
            cursor.batchSize(this._fetchSize);
        }
        if (this._maxRows > 0) {
            cursor.limit(this._maxRows);
        }
        this._last = new MongoResultSet(cursor);
        return this._last;
    }

    @Override
    public int getQueryTimeout() {
        throw new RuntimeException("query timeout not done");
    }

    @Override
    public void setQueryTimeout(int seconds) {
        throw new RuntimeException("query timeout not done");
    }

    @Override
    public int getFetchSize() {
        return this._fetchSize;
    }

    @Override
    public void setFetchSize(int rows) {
        this._fetchSize = rows;
    }

    @Override
    public int getMaxRows() {
        return this._maxRows;
    }

    @Override
    public void setMaxRows(int max) {
        this._maxRows = max;
    }

    @Override
    public int getFetchDirection() {
        throw new RuntimeException("fetch direction not done yet");
    }

    @Override
    public void setFetchDirection(int direction) {
        throw new RuntimeException("fetch direction not done yet");
    }

    @Override
    public int getMaxFieldSize() {
        throw new RuntimeException("max field size not supported");
    }

    @Override
    public void setMaxFieldSize(int max) {
        throw new RuntimeException("max field size not supported");
    }

    @Override
    public boolean getMoreResults() {
        throw new RuntimeException("getMoreResults not supported");
    }

    @Override
    public boolean getMoreResults(int current) {
        throw new RuntimeException("getMoreResults not supported");
    }

    @Override
    public ResultSet getResultSet() {
        return this._last;
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException("warning not supported yet");
    }

    @Override
    public void setCursorName(String name) {
        throw new UnsupportedOperationException("can't set cursor name");
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        if (!enable) {
            throw new RuntimeException("why do you want to turn escape processing off?");
        }
    }

    @Override
    public int getResultSetConcurrency() {
        return this._concurrency;
    }

    @Override
    public int getResultSetHoldability() {
        return this._holdability;
    }

    @Override
    public int getResultSetType() {
        return this._type;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

