/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.jdbc.MongoResultSetMetadata;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MongoResultSet
implements ResultSet {
    final DBCursor _cursor;
    final FieldLookup _fields = new FieldLookup();
    DBObject _cur;
    int _row = 0;
    boolean _closed = false;

    MongoResultSet(DBCursor cursor) {
        this._cursor = cursor;
        this._fields.init(cursor.getKeysWanted());
    }

    @Override
    public void clearWarnings() {
    }

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public int getConcurrency() {
        return 1007;
    }

    @Override
    public int getType() {
        return 1003;
    }

    @Override
    public void setFetchDirection(int direction) {
        if (direction == this.getFetchDirection()) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchDirection() {
        return 1;
    }

    @Override
    public String getCursorName() {
        return "MongoResultSet: " + this._cursor.toString();
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return new MongoResultSetMetadata(this._fields.getAllFieldNames());
    }

    @Override
    public SQLWarning getWarnings() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int rows) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement getStatement() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() {
        return 1;
    }

    @Override
    public boolean absolute(int row) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean first() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() {
        return this._row;
    }

    @Override
    public boolean isAfterLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBeforeFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean last() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToCurrentRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean previous() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean relative(int rows) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void insertRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void cancelRowUpdates() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(int columnIndex, Array x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String columnName, Array x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, Blob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, InputStream x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream x, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String columnName, InputStream x, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String columnName, boolean x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int columnIndex, byte x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String columnName, byte x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String columnName, byte[] x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Clob x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int columnIndex, Reader x, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String columnName, Reader x, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int columnIndex, Date x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String columnName, Date x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int columnIndex, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String columnName, double x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int columnIndex, float x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String columnName, float x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int columnIndex, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String columnName, int x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int columnIndex, long x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String columnName, long x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int columnIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnName, Object x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String columnName, Ref x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String columnName, RowId x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int columnIndex, short x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String columnName, short x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String columnName, SQLXML xmlObject) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int columnIndex, String x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String columnName, String x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int columnIndex, Time x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String columnName, Time x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(int i) {
        return this.getArray(this._find(i));
    }

    @Override
    public Array getArray(String colName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) {
        return this.getAsciiStream(this._find(columnIndex));
    }

    @Override
    public InputStream getAsciiStream(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) {
        return this.getBigDecimal(this._find(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) {
        return this.getBigDecimal(this._find(columnIndex), scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) {
        return this.getBinaryStream(this._find(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(int i) {
        return this.getBlob(this._find(i));
    }

    @Override
    public Blob getBlob(String colName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        return this.getBoolean(this._find(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnName) {
        Object x = this._cur.get(columnName);
        if (x == null) {
            return false;
        }
        return (Boolean)x;
    }

    @Override
    public byte getByte(int columnIndex) {
        return this.getByte(this._find(columnIndex));
    }

    @Override
    public byte getByte(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(int columnIndex) {
        return this.getBytes(this._find(columnIndex));
    }

    @Override
    public byte[] getBytes(String columnName) {
        return (byte[])this._cur.get(columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) {
        return this.getCharacterStream(this._find(columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(int i) {
        return this.getClob(this._find(i));
    }

    @Override
    public Clob getClob(String colName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int columnIndex) {
        return this.getDate(this._find(columnIndex));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) {
        return this.getDate(this._find(columnIndex), cal);
    }

    @Override
    public Date getDate(String columnName) {
        return (Date)this._cur.get(columnName);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int columnIndex) {
        return this.getDouble(this._find(columnIndex));
    }

    @Override
    public double getDouble(String columnName) {
        return this._getNumber(columnName).doubleValue();
    }

    @Override
    public float getFloat(int columnIndex) {
        return this.getFloat(this._find(columnIndex));
    }

    @Override
    public float getFloat(String columnName) {
        return this._getNumber(columnName).floatValue();
    }

    @Override
    public int getInt(int columnIndex) {
        return this.getInt(this._find(columnIndex));
    }

    @Override
    public int getInt(String columnName) {
        return this._getNumber(columnName).intValue();
    }

    @Override
    public long getLong(int columnIndex) {
        return this.getLong(this._find(columnIndex));
    }

    @Override
    public long getLong(String columnName) {
        return this._getNumber(columnName).longValue();
    }

    @Override
    public short getShort(int columnIndex) {
        return this.getShort(this._find(columnIndex));
    }

    @Override
    public short getShort(String columnName) {
        return this._getNumber(columnName).shortValue();
    }

    Number _getNumber(String n) {
        Number x = (Number)this._cur.get(n);
        if (x == null) {
            return 0;
        }
        return x;
    }

    @Override
    public Object getObject(int columnIndex) {
        if (columnIndex == 0) {
            return this._cur;
        }
        return this.getObject(this._find(columnIndex));
    }

    public Object getObject(int i, Map map) {
        if (i == 0) {
            return this._cur;
        }
        return this.getObject(this._find(i), map);
    }

    @Override
    public Object getObject(String columnName) {
        return this._cur.get(columnName);
    }

    public Object getObject(String colName, Map map) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int i) {
        return this.getRef(this._find(i));
    }

    @Override
    public Ref getRef(String colName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int i) {
        return this.getRowId(this._find(i));
    }

    @Override
    public RowId getRowId(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) {
        return this.getSQLXML(this._find(columnIndex));
    }

    @Override
    public SQLXML getSQLXML(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(int columnIndex) {
        return this.getString(this._find(columnIndex));
    }

    @Override
    public String getString(String columnName) {
        Object x = this._cur.get(columnName);
        if (x == null) {
            return null;
        }
        return x.toString();
    }

    @Override
    public Time getTime(int columnIndex) {
        return this.getTime(this._find(columnIndex));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) {
        return this.getTime(this._find(columnIndex), cal);
    }

    @Override
    public Time getTime(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String columnName, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        return this.getTimestamp(this._find(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) {
        return this.getTimestamp(this._find(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) {
        return this.getUnicodeStream(this._find(columnIndex));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getURL(this._find(columnIndex));
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        try {
            return new URL(this.getString(columnName));
        }
        catch (MalformedURLException m) {
            throw new SQLException("bad url [" + this.getString(columnName) + "]");
        }
    }

    @Override
    public String getNString(int columnIndex) {
        return this.getNString(this._find(columnIndex));
    }

    @Override
    public String getNString(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int columnIndex) {
        return this.getNClob(this._find(columnIndex));
    }

    @Override
    public NClob getNClob(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) {
        return this.getNCharacterStream(this._find(columnIndex));
    }

    @Override
    public Reader getNCharacterStream(String columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int columnIndex, String nString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String columnLabel, String nString) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean wasNull() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int findColumn(String columnName) {
        return this._fields.get(columnName);
    }

    public String _find(int i) {
        return this._fields.get(i);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() {
        if (!this._cursor.hasNext()) {
            return false;
        }
        this._cur = this._cursor.next();
        return true;
    }

    class FieldLookup {
        final Map<Integer, String> _ids = new HashMap<Integer, String>();
        final Map<String, Integer> _strings = new HashMap<String, Integer>();

        FieldLookup() {
        }

        void init(DBObject o) {
            if (o == null) {
                return;
            }
            for (String key : o.keySet()) {
                this.get(key);
            }
        }

        int get(String s) {
            Integer i = this._strings.get(s);
            if (i == null) {
                i = this._strings.size() + 1;
                this._store(i, s);
            }
            return i;
        }

        String get(int i) {
            String s = this._ids.get(i);
            if (s != null) {
                return s;
            }
            this.init(MongoResultSet.this._cur);
            s = this._ids.get(i);
            if (s != null) {
                return s;
            }
            throw new IllegalArgumentException(i + " is not a valid column id");
        }

        void _store(Integer i, String s) {
            this._ids.put(i, s);
            this._strings.put(s, i);
        }

        Collection<String> getAllFieldNames() {
            return this._strings.keySet();
        }
    }
}

