/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.DBAddress;
import com.mongodb.Mongo;
import com.mongodb.jdbc.MongoConnection;
import com.mongodb.jdbc.MongoSQLException;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public class MongoDriver
implements Driver {
    static final String PREFIX = "mongodb://";

    @Override
    public boolean acceptsURL(String url) {
        return url.startsWith(PREFIX);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url.startsWith(PREFIX)) {
            url = url.substring(PREFIX.length());
        }
        if (url.indexOf("/") < 0) {
            throw new MongoSQLException("bad url: " + url);
        }
        try {
            DBAddress addr = new DBAddress(url);
            return new MongoConnection(Mongo.connect((DBAddress)addr));
        }
        catch (UnknownHostException uh) {
            throw new MongoSQLException("bad url: " + uh);
        }
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 1;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        throw new UnsupportedOperationException("getPropertyInfo doesn't work yet");
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    public static void install() {
    }

    static {
        try {
            DriverManager.registerDriver(new MongoDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

