/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.jdbc;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.jdbc.MongoSQLException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.update.Update;

public class Executor {
    static final boolean D = false;
    final DB _db;
    final String _sql;
    final Statement _statement;
    List _params;
    int _pos;

    Executor(DB db, String sql) throws MongoSQLException {
        this._db = db;
        this._sql = sql;
        this._statement = this.parse(sql);
    }

    void setParams(List params) {
        this._pos = 1;
        this._params = params;
    }

    DBCursor query() throws MongoSQLException {
        if (!(this._statement instanceof Select)) {
            throw new IllegalArgumentException("not a query sql statement");
        }
        Select select = (Select)this._statement;
        if (!(select.getSelectBody() instanceof PlainSelect)) {
            throw new UnsupportedOperationException("can only handle PlainSelect so far");
        }
        PlainSelect ps = (PlainSelect)select.getSelectBody();
        if (!(ps.getFromItem() instanceof Table)) {
            throw new UnsupportedOperationException("can only handle regular tables");
        }
        DBCollection coll = this.getCollection((Table)ps.getFromItem());
        BasicDBObject fields = new BasicDBObject();
        for (Object o : ps.getSelectItems()) {
            SelectItem si = (SelectItem)o;
            if (si instanceof AllColumns) {
                if (fields.size() <= 0) break;
                throw new UnsupportedOperationException("can't have * and fields");
            }
            if (si instanceof SelectExpressionItem) {
                SelectExpressionItem sei = (SelectExpressionItem)si;
                fields.put(this.toFieldName(sei.getExpression()), (Object)1);
                continue;
            }
            throw new UnsupportedOperationException("unknown select item: " + si.getClass());
        }
        DBObject query = this.parseWhere(ps.getWhere());
        DBCursor c = coll.find(query, (DBObject)fields);
        List orderBylist = ps.getOrderByElements();
        if (orderBylist != null && orderBylist.size() > 0) {
            BasicDBObject order = new BasicDBObject();
            for (int i = 0; i < orderBylist.size(); ++i) {
                OrderByElement o = (OrderByElement)orderBylist.get(i);
                order.put(o.getColumnReference().toString(), (Object)(o.isAsc() ? 1 : -1));
            }
            c.sort((DBObject)order);
        }
        return c;
    }

    int writeop() throws MongoSQLException {
        if (this._statement instanceof Insert) {
            return this.insert((Insert)this._statement);
        }
        if (this._statement instanceof Update) {
            return this.update((Update)this._statement);
        }
        if (this._statement instanceof Drop) {
            return this.drop((Drop)this._statement);
        }
        throw new RuntimeException("unknown write: " + this._statement.getClass());
    }

    int insert(Insert in) throws MongoSQLException {
        if (in.getColumns() == null) {
            throw new MongoSQLException.BadSQL("have to give column names to insert");
        }
        DBCollection coll = this.getCollection(in.getTable());
        if (!(in.getItemsList() instanceof ExpressionList)) {
            throw new UnsupportedOperationException("need ExpressionList");
        }
        BasicDBObject o = new BasicDBObject();
        List valueList = ((ExpressionList)in.getItemsList()).getExpressions();
        if (in.getColumns().size() != valueList.size()) {
            throw new MongoSQLException.BadSQL("number of values and columns have to match");
        }
        for (int i = 0; i < valueList.size(); ++i) {
            o.put(in.getColumns().get(i).toString(), this.toConstant((Expression)valueList.get(i)));
        }
        coll.insert((DBObject)o);
        return 1;
    }

    int update(Update up) throws MongoSQLException {
        DBObject query = this.parseWhere(up.getWhere());
        BasicDBObject set = new BasicDBObject();
        for (int i = 0; i < up.getColumns().size(); ++i) {
            String k = up.getColumns().get(i).toString();
            Expression v = (Expression)up.getExpressions().get(i);
            set.put(k.toString(), this.toConstant(v));
        }
        BasicDBObject mod = new BasicDBObject("$set", (Object)set);
        DBCollection coll = this.getCollection(up.getTable());
        coll.update(query, (DBObject)mod);
        return 1;
    }

    int drop(Drop d) {
        DBCollection c = this._db.getCollection(d.getName());
        c.drop();
        return 1;
    }

    String toFieldName(Expression e) {
        if (e instanceof StringValue) {
            return e.toString();
        }
        if (e instanceof Column) {
            return e.toString();
        }
        throw new UnsupportedOperationException("can't turn [" + e + "] " + e.getClass() + " into field name");
    }

    Object toConstant(Expression e) {
        if (e instanceof StringValue) {
            return ((StringValue)e).getValue();
        }
        if (e instanceof DoubleValue) {
            return ((DoubleValue)e).getValue();
        }
        if (e instanceof LongValue) {
            return ((LongValue)e).getValue();
        }
        if (e instanceof NullValue) {
            return null;
        }
        if (e instanceof JdbcParameter) {
            return this._params.get(this._pos++);
        }
        throw new UnsupportedOperationException("can't turn [" + e + "] " + e.getClass().getName() + " into constant ");
    }

    DBObject parseWhere(Expression e) {
        BasicDBObject o = new BasicDBObject();
        if (e == null) {
            return o;
        }
        if (!(e instanceof EqualsTo)) {
            throw new UnsupportedOperationException("can't handle: " + e.getClass() + " yet");
        }
        EqualsTo eq = (EqualsTo)e;
        o.put(this.toFieldName(eq.getLeftExpression()), this.toConstant(eq.getRightExpression()));
        return o;
    }

    Statement parse(String s) throws MongoSQLException {
        s = s.trim();
        try {
            return new CCJSqlParserManager().parse((Reader)new StringReader(s));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MongoSQLException.BadSQL(s);
        }
    }

    DBCollection getCollection(Table t) {
        return this._db.getCollection(t.toString());
    }
}

