#pragma once
#include <stdlib.h>
#include <math.h>
#include "LoadObj.h"
#include "glut.h"

class Model
{
public:
	struct Color
	{
		Color()
		{
			r = 0.0f;
			g = 0.0f;
			b = 0.0f;
		}
		Color(const float p_r, const float p_g, const float p_b)
		{
			r = p_r;
			g = p_g;
			b = p_b;
		}
		float r;
		float g;
		float b;
	};

	Model(const char* p_filepath, const Color p_color);
	~Model();
	void Update(const float p_deltaTime);
	void Render();
	void SetPosition(const float p_x, const float p_y, const float p_z);
	void SetPosition(const Vec3 p_position);
	const Vec3 GetPosition() const;
	void SetHeading(const float p_x, const float p_y, const float p_z);
	void SetHeading(const Vec3 p_heading);
	const Vec3 GetHeading() const;
	void SetColor(const float p_red, const float p_green, const float p_blue);
	void SetColor(const Color p_color);
	void SetBaseRotation(const float p_x, const float p_y, const float p_z);
	void SetBaseRotation(const Vec3 p_rotation);
	const Vec3 GetBaseRotation() const;
	void SetHeadingRotation(const float p_x, const float p_y, const float p_z);
	void SetHeadingRotation(const Vec3 p_rotation);
	const Vec3 GetHeadingRotation() const;
	void SetVelocity(const float p_velocity);
	const float GetVelocity() const;
	const bool IsShip();
	void IsShip(const bool p_IsShip);
	const bool IsVisible() const { return m_isVisible; };
	void IsVisible(const bool p_isVisible) { m_isVisible = p_isVisible; };

	const bool IsCollideable();
	void IsCollideable(const bool collideable);
	const bool CollidedWith(Model* target);
	const Vec3 GetCenter() const;
	void SetRadius(const float p_radius);
	const float GetRadius() const;


protected:
	const char * m_filepath;
	std::vector<Vec3> m_vertices;
	std::vector<Vec3> m_normals;
	Vec3 m_position;
	Vec3 m_heading;
	Vec3 m_baseRotation;
	Vec3 m_headingRotation;
	Color m_color;
	Primitive m_primitive;
	float m_velocity;
	
	bool m_isVisible;
	bool m_loaded;
	bool m_IsShip;

	float m_radius;
	bool m_collideable;
};

