# Haskell-Data-Analysis-Cookbook
This is the accompanying source code for [Haskell Data Analysis Cookbook](http://haskelldata.com).

The latest source code is available on GitHub: https://github.com/BinRoot/Haskell-Data-Analysis-Cookbook

# Summary
### [Chapter 1](/Ch01/README.md)
*The Hunt for Data*, identifies core approaches in reading data from various external sources such as **CSV**, **JSON**, **XML**, **HTML**, **MongoDB**, and **SQLite**.

### [Chapter 2](/Ch02/README.md)
*Integrity and Inspection*, explains the importance of cleaning data through recipes about **trimming whitespace**, **lexing**, and **regular expression matching**.

### [Chapter 3](/Ch03/README.md)
*The Science of Words*, introduces common string manipulation algorithms including **base conversions**, **substring matching**, and **computing the edit distance**.

### [Chapter 4](/Ch04/README.md)
*Data Hashing*, covers essential hashing functions such as **MD5**, **SHA256**, **GeoHashing**, and **perceptual hashing**.

### [Chapter 5](/Ch05/README.md)
*A Dance with Trees*, establishes an understanding of the tree data structure through examples including **tree traversals**, **balancing trees**, and **Huffman coding**.

### [Chapter 6](/Ch06/README.md)
*Graph Fundamentals*, manifests rudimentary algorithms for graphical networks such as **graph traversals**, **visualization**, and **maximal clique detection**.

### [Chapter 7](/Ch07/README.md)
*Statistics and Analysis*, begins the investigation of important data analysis techniques encompassing **regression algorithms**, **Bayesian networks**, and **neural networks**.

### [Chapter 8](/Ch08/README.md)
*Clustering and Classification*, involves quintessential analysis methods involving **k-means clustering**, **hierarchical clustering**, **constructing decision trees**, and **implementing the k-Nearest Neighbors classifier**.

### [Chapter 9](/Ch09/README.md)
*Parallel and Concurrent Design*, introduces advance topics in Haskell such as **forking IO actions**, **mapping over lists in parallel**, and **benchmarking performance**.

### [Chapter 10](/Ch10/README.md)
*Real-time Fugue*, incorporates streamed data interactions from **Twitter**, **Internet Relay Chat (IRC)**, and **sockets**.

### [Chapter 11](/Ch11/README.md)
*Stunning Visuals*, comprises of sundry approaches to plotting graphs including **line charts**, **bar graphs**, **scatter plots**, and **D3.js visualizations**.

### [Chapter 12](/Ch12/README.md)
*The Final Exporting*, concludes the book with an enumeration of algorithms for exporting data to **CSV**, **JSON**, **HTML**, **MongoDB**, and **SQLite**.

# Artwork Attribution
Illustrations by [Lonku](http://lonku.tumblr.com/).
