/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Event;
import org.jgroups.annotations.Property;
import org.jgroups.stack.Protocol;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class DELAY
extends Protocol {
    @Property(description="Number of millisconds to delay passing a message up the stack")
    protected int in_delay;
    @Property(description="Number of millisconds to delay passing a message down the stack")
    protected int out_delay;

    public int getInDelay() {
        return this.in_delay;
    }

    public void setInDelay(int in_delay) {
        this.in_delay = in_delay;
    }

    public int getOutDelay() {
        return this.out_delay;
    }

    public void setOutDelay(int out_delay) {
        this.out_delay = out_delay;
    }

    @Override
    public Object down(Event evt) {
        if (this.out_delay > 0 && evt.getType() == 1) {
            Util.sleep(DELAY.computeDelay(this.out_delay));
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        if (this.in_delay > 0 && evt.getType() == 1) {
            Util.sleep(DELAY.computeDelay(this.in_delay));
        }
        return this.up_prot.up(evt);
    }

    @Override
    public void up(MessageBatch batch) {
        if (this.in_delay > 0) {
            Util.sleep(DELAY.computeDelay(this.in_delay));
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    static int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }
}

