// Fill out your copyright notice in the Description page of Project Settings.

#include "RPG.h"
#include "CombatUIWidget.h"
#include "../Combat/CombatEngine.h"
#include "../Combat/Actions/TestCombatAction.h"

void UCombatUIWidget::BeginMakeDecision(UGameCharacter* target)
{
	this->currentTarget = target;
	this->finishedDecision = false;

	ShowActionsPanel(target);
}

bool UCombatUIWidget::MakeDecision(float DeltaSeconds)
{
	return this->finishedDecision;
}

void UCombatUIWidget::AttackTarget(UGameCharacter* target)
{
	TestCombatAction* action = new TestCombatAction(target);
	this->currentTarget->combatAction = action;

	this->finishedDecision = true;
}

TArray<UGameCharacter*> UCombatUIWidget::GetCharacterTargets()
{
	if (this->currentTarget->isPlayer)
	{
		return this->currentTarget->combatInstance->enemyParty;
	}
	else
	{
		return this->currentTarget->combatInstance->playerParty;
	}
}



