// Fill out your copyright notice in the Description page of Project Settings.

#include "RPG.h"
#include "RPGGameMode.h"
#include "RPGCharacter.h"
#include "RPGGameInstance.h"

ARPGGameMode::ARPGGameMode(const class FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
	DefaultPawnClass = ARPGCharacter::StaticClass();
}

void ARPGGameMode::BeginPlay()
{

	Cast<URPGGameInstance>(GetGameInstance())->Init();
	
}

void ARPGGameMode::Tick(float DeltaTime)
{
	if (this->currentCombatInstance != nullptr)
	{
		bool combatOver = this->currentCombatInstance->Tick(DeltaTime
		);
		if (combatOver)
		{
			if (this->currentCombatInstance->phase == CombatPhase::
				CPHASE_GameOver)
			{
				UE_LOG(LogTemp, Log, TEXT("Player loses combat, game over" ) );

				Cast<URPGGameInstance>(GetGameInstance())->PrepareReset();

				UUserWidget* GameOverUIInstance = CreateWidget<UUserWidget>(
					GetGameInstance(), this->GameOverUIClass);
				GameOverUIInstance->AddToViewport();

			}
			else if (this->currentCombatInstance->phase == CombatPhase::
				CPHASE_Victory)
			{
				UE_LOG(LogTemp, Log, TEXT("Player wins combat"));
			}

			for (int i = 0; i < this->currentCombatInstance->
				playerParty.Num(); i++)
			{
				this->currentCombatInstance->playerParty[i]->decisionMaker =
					nullptr;
			}

			UGameplayStatics::GetPlayerController(GetWorld(), 0)->bShowMouseCursor=false;

			// enable player actor
			UGameplayStatics::GetPlayerController(GetWorld(), 0)->
				SetActorTickEnabled(true);

			this->CombatUIInstance->RemoveFromViewport();
			this->CombatUIInstance = nullptr;

			delete(this->currentCombatInstance);
			this->currentCombatInstance = nullptr;
			this->enemyParty.Empty();

			
		}
	}
}
void ARPGGameMode::TestCombat()
{
	// locate enemies asset
	UDataTable* enemyTable = Cast<UDataTable>(StaticLoadObject(
		UDataTable::StaticClass(), NULL,
		TEXT("DataTable'/Game/Data/Enemies.Enemies'")));

		if (enemyTable == NULL)
		{
			UE_LOG(LogTemp, Error, TEXT("Enemies data table not found!"
			));
			return;
		}

	// locate enemy
	FEnemyInfo* row = enemyTable->FindRow<FEnemyInfo>(TEXT("S1"),
		TEXT("LookupEnemyInfo"));

	if (row == NULL)
	{
		UE_LOG(LogTemp, Error, TEXT("Enemy ID 'S1' not found!"));
		return;
	}

	// disable player actor
	UGameplayStatics::GetPlayerController(GetWorld(), 0)->
		SetActorTickEnabled(false);

	// add character to enemy party
	UGameCharacter* enemy = UGameCharacter::CreateGameCharacter(
		row, this);
	this->enemyParty.Add(enemy);

	URPGGameInstance* gameInstance = Cast<URPGGameInstance>(
		GetGameInstance());

	this->currentCombatInstance = new CombatEngine(gameInstance->
		PartyMembers, this->enemyParty);

	UE_LOG(LogTemp, Log, TEXT("Combat started"));

	this->CombatUIInstance = CreateWidget<UCombatUIWidget>(
		GetGameInstance(), this->CombatUIClass);
	this->CombatUIInstance->AddToViewport();

	UGameplayStatics::GetPlayerController(GetWorld(), 0)->bShowMouseCursor = true;


	for (int i = 0; i < gameInstance->PartyMembers.Num(); i++)
	{
		this->CombatUIInstance->AddPlayerCharacterPanel(gameInstance->PartyMembers[i]);
		gameInstance->PartyMembers[i]->decisionMaker = this->CombatUIInstance;
	}


	for (int i = 0; i < this->enemyParty.Num(); i++)
		this->CombatUIInstance->AddEnemyCharacterPanel(this->enemyParty[i]);

}


