// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "Data/FCharacterInfo.h"
#include "Data/FEnemyInfo.h"
#include "Data/FCharacterClassInfo.h"
#include "Combat/Actions/ICombatAction.h"
#include "Combat/DecisionMakers/IDecisionMaker.h"
#include "GameCharacter.generated.h"

class CombatEngine;
class ICombatAction;
class IDecisionMaker;

UCLASS(BlueprintType)
class RPG_API UGameCharacter : public UObject
{
	GENERATED_BODY()

public:
	FCharacterClassInfo* ClassInfo;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		FString CharacterName;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 MHP;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 MMP;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 HP;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 MP;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 ATK;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 DEF;

	UPROPERTY(EditAnywhere, BlueprintReadWrite, Category =
		CharacterInfo)
		int32 LUCK;

	UPROPERTY(BlueprintReadWrite, EditAnywhere, Category =
		CharacterInfo)
		int32 Gold;


	CombatEngine* combatInstance;
	ICombatAction* combatAction;
	IDecisionMaker* decisionMaker;

	bool isPlayer;

	UGameCharacter* SelectTarget();

public:
	static UGameCharacter* CreateGameCharacter(FCharacterInfo*
		characterInfo, UObject* outer);
	static UGameCharacter* CreateGameCharacter(FEnemyInfo* enemyInfo,
		UObject* outer);

public:
	void BeginDestroy() override;
	void BeginMakeDecision();
	bool MakeDecision(float DeltaSeconds);

	void BeginExecuteAction();
	bool ExecuteAction(float DeltaSeconds);

};

